package com.ejie.ab18a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.dao.Ab18aPeticionEnvioDao;
import com.ejie.ab18a.entidades.Ab18aUsuario;
import com.ejie.ab18a.model.Ab18aEnvio;
import com.ejie.ab18a.model.Ab18aFiltroMonitor;
import com.ejie.ab18a.model.Ab18aIncoherencia;
import com.ejie.ab18a.model.Ab18aPeticionDetalle;
import com.ejie.ab18a.model.Ab18aPeticionEnvio;
import com.ejie.ab18a.ws.model.Ab18aDatosRespuestaEsentool;
import com.ejie.ab18a.ws.model.Ab18aValidacionBoletin;
import com.ejie.ab18a.ws.model.DatosBoletin;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab18a01s00ServiceImpl generated by XXXX, 03-feb-2017 12:08:05.
 * 
 * @author XXXX
 */

@Service(value = "ab18aPeticionEnvioService")
public class Ab18aPeticionEnvioServiceImpl implements Ab18aPeticionEnvioService {

	@Autowired
	private Ab18aPeticionEnvioDao ab18aPeticionEnvioDao;

	/**
	 * Inserts a single row in the Ab18a01s00 table.
	 * 
	 * @param peticionEnvio
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aPeticionEnvio add(Ab18aPeticionEnvio peticionEnvio) throws Exception {

		return this.ab18aPeticionEnvioDao.add(peticionEnvio);

	}

	/**
	 * Updates a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aPeticionEnvio update(Ab18aPeticionEnvio peticionEnvio) {
		return this.ab18aPeticionEnvioDao.update(peticionEnvio);
	}

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	public Ab18aPeticionEnvio find(Ab18aPeticionEnvio peticionEnvio) {
		return (Ab18aPeticionEnvio) this.ab18aPeticionEnvioDao.find(peticionEnvio);
	}

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param peticionEnvio
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	public DatosBoletin findPeticionRecogida(Ab18aPeticionEnvio peticionEnvio) {
		return (DatosBoletin) this.ab18aPeticionEnvioDao.findPeticionRecogida(peticionEnvio);
	}

	/**
	 * Encuentra registros en la tabla AB18A08T00.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aDatosRespuestaEsentool
	 */
	public List<String> findTedLinks(Integer idPeticionEnvio) {
		return (List<String>) this.ab18aPeticionEnvioDao.findTedLinks(idPeticionEnvio);
	}

	/**
	 * Finds a list of rows in the Ab18a09s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aValidacionBoletin
	 */
	public List<Ab18aValidacionBoletin> findValidaciones(Integer idPeticionEnvio) {
		return (List<Ab18aValidacionBoletin>) this.ab18aPeticionEnvioDao.findValidaciones(idPeticionEnvio);
	}

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aDatosRespuestaEsentool
	 */
	public Ab18aDatosRespuestaEsentool findRespuestaWS(Integer idPeticionEnvio) {
		return (Ab18aDatosRespuestaEsentool) this.ab18aPeticionEnvioDao.findRespuestaWS(idPeticionEnvio);
	}

	/**
	 * Deletes a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ab18aPeticionEnvio peticionEnvio) {
		this.ab18aPeticionEnvioDao.remove(peticionEnvio);
	}

	/**
	 * Finds a list of rows in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a01s00>
	 */
	public List<Ab18aPeticionEnvio> findAll(Ab18aPeticionEnvio peticionEnvio, JQGridRequestDto jqGridRequestDto) {
		return (List<Ab18aPeticionEnvio>) this.ab18aPeticionEnvioDao.findAll(peticionEnvio, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab18a01s00 table using like.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a01s00>
	 */
	public List<Ab18aPeticionEnvio> findAllLike(Ab18aPeticionEnvio peticionEnvio, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Ab18aPeticionEnvio>) this.ab18aPeticionEnvioDao.findAllLike(peticionEnvio, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Ab18aPeticionEnvio filterAb18aPeticionEnvio, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab18aPeticionEnvioDao.removeMultiple(filterAb18aPeticionEnvio, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Ab18a01s00>
	 */
	public JQGridResponseDto<Ab18aPeticionEnvio> filter(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Ab18aPeticionEnvio> listaAb18a01s00 = this.ab18aPeticionEnvioDao.findAllLike(filterAb18a01s00, jqGridRequestDto, false);
		Long recordNum = this.ab18aPeticionEnvioDao.findAllLikeCount(filterAb18a01s00 != null ? filterAb18a01s00 : new Ab18aPeticionEnvio(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Ab18aPeticionEnvio>> reorderSelection = this.ab18aPeticionEnvioDao.reorderSelection(filterAb18a01s00, jqGridRequestDto,
					startsWith);
			return new JQGridResponseDto<Ab18aPeticionEnvio>(jqGridRequestDto, recordNum, listaAb18a01s00, reorderSelection);
		}
		return new JQGridResponseDto<Ab18aPeticionEnvio>(jqGridRequestDto, recordNum, listaAb18a01s00);
	}

	/**
	 * Searches rows in the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param searchAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a01s00>>
	 */
	public List<TableRowDto<Ab18aPeticionEnvio>> search(Ab18aPeticionEnvio filterAb18a01s00, Ab18aPeticionEnvio searchAb18a01s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab18aPeticionEnvioDao.search(filterAb18a01s00, searchAb18a01s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab18aPeticionEnvioDao.reorderSelection(filterAb18a01s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a01s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>> jerarquia(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Ab18aPeticionEnvio>> listaAb18a01s00 = this.ab18aPeticionEnvioDao.findAllLikeJerarquia(filterAb18a01s00, jqGridRequestDto);
		Long recordNum = this.ab18aPeticionEnvioDao.findAllLikeCountJerarquia(filterAb18a01s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>>(jqGridRequestDto, recordNum, listaAb18a01s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a01s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>> jerarquiaChildren(Ab18aPeticionEnvio filterAb18a01s00,
			JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN, this.ab18aPeticionEnvioDao.findAllChild(filterAb18a01s00, jqGridRequestDto));
		return jqGridResponseDto;
	}

	public Ab18aPeticionEnvio findIfExists(Ab18aPeticionEnvio peticionAux) throws Exception {
		return this.ab18aPeticionEnvioDao.findIfExists(peticionAux);
	}

	@Override
	public DatosBoletin findPeticionById(Integer idPeticionEnvio) {
		return this.ab18aPeticionEnvioDao.findPeticionById(idPeticionEnvio);
	}

	@Override
	public List<Ab18aEnvio> findPeticionesCuadro(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario, JQGridRequestDto jqGridRequestDto) {
		return this.ab18aPeticionEnvioDao.findPeticionesCuadro(filtroMonitor, usuario, jqGridRequestDto);
	}

	@Override
	public Long findAllCount(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario) {
		return this.ab18aPeticionEnvioDao.findAllCount(filtroMonitor, usuario);
	}

	public Ab18aPeticionEnvio findZipById(Integer idPeticionEnvio) {
		return this.ab18aPeticionEnvioDao.findZipById(idPeticionEnvio);
	}

	public void paralizarReanudarPeticion(Integer idPeticion, Integer valorParalizar) throws Exception {
		Ab18aPeticionEnvio peticion = new Ab18aPeticionEnvio();

		peticion.setT01IdPeticionEnvio(idPeticion);
		peticion.setT01Paralizada(valorParalizar);

		try {
			this.ab18aPeticionEnvioDao.paralizarReanudarPeticion(peticion);
		} catch (Exception e) {
			throw e;
		}
	}

	public List<Ab18aIncoherencia> findIncoherencias(Ab18aIncoherencia filtroIncoherencia, Ab18aUsuario usuario, JQGridRequestDto jqGridRequestDto) {
		return this.ab18aPeticionEnvioDao.findIncoherencias(filtroIncoherencia, usuario, jqGridRequestDto);
	}

	public Long findAllCountIncoherencias(Ab18aIncoherencia filtroIncoherencias, Ab18aUsuario usuario) {
		return this.ab18aPeticionEnvioDao.findAllCountIncoherencias(filtroIncoherencias, usuario);
	}

	public void deshabilitarIncoherencia(String codExpediente) {
		this.ab18aPeticionEnvioDao.deshabilitarIncoherencia(codExpediente);
	}

	public Ab18aPeticionDetalle findDetallePeticionById(Integer idPeticion) throws Exception {
		return this.ab18aPeticionEnvioDao.findDetallePeticionById(idPeticion);
	}

	public void reactivar(Integer idPeticion) throws Exception {
		this.ab18aPeticionEnvioDao.reactivar(idPeticion);
	}

	public Integer findNumIntentosById(Integer idPeticion) throws Exception {
		return this.ab18aPeticionEnvioDao.findNumIntentosById(idPeticion);
	}
}
